/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.RpcRequestBuilder;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamFactory;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.rpc.impl.ClientSerializationStreamReader;
import com.google.gwt.user.client.rpc.impl.ClientSerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.RequestCallbackAdapter;
import com.google.gwt.user.client.rpc.impl.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteServiceProxy
implements SerializationStreamFactory,
ServiceDefTarget {
    private static final String RPC_CONTENT_TYPE = "text/x-gwt-rpc; charset=utf-8";
    private static int requestId;
    private final String moduleBaseURL;
    private String remoteServiceURL;
    private RpcRequestBuilder rpcRequestBuilder;
    private final String serializationPolicyName;
    private final Serializer serializer;

    public static native JavaScriptObject bytesStat(String var0, int var1, int var2, String var3);

    public static native boolean isStatsAvailable();

    public static native boolean stats(JavaScriptObject var0);

    public static native JavaScriptObject timeStat(String var0, int var1, String var2);

    protected static int getNextRequestId() {
        return requestId++;
    }

    @Deprecated
    protected static int getRequestId() {
        return requestId;
    }

    static boolean isReturnValue(String encodedResponse) {
        return encodedResponse.startsWith("//OK");
    }

    static boolean isThrownException(String encodedResponse) {
        return encodedResponse.startsWith("//EX");
    }

    private static String getEncodedInstance(String encodedResponse) {
        if (RemoteServiceProxy.isReturnValue(encodedResponse) || RemoteServiceProxy.isThrownException(encodedResponse)) {
            return encodedResponse.substring(4);
        }
        return encodedResponse;
    }

    protected RemoteServiceProxy(String moduleBaseURL, String remoteServiceRelativePath, String serializationPolicyName, Serializer serializer) {
        this.moduleBaseURL = moduleBaseURL;
        if (remoteServiceRelativePath != null) {
            this.remoteServiceURL = moduleBaseURL + remoteServiceRelativePath;
        }
        this.serializer = serializer;
        this.serializationPolicyName = serializationPolicyName;
    }

    @Override
    public SerializationStreamReader createStreamReader(String encoded) throws SerializationException {
        ClientSerializationStreamReader clientSerializationStreamReader = new ClientSerializationStreamReader(this.serializer);
        clientSerializationStreamReader.prepareToRead(RemoteServiceProxy.getEncodedInstance(encoded));
        return clientSerializationStreamReader;
    }

    @Override
    public SerializationStreamWriter createStreamWriter() {
        ClientSerializationStreamWriter clientSerializationStreamWriter = new ClientSerializationStreamWriter(this.serializer, this.moduleBaseURL, this.serializationPolicyName);
        clientSerializationStreamWriter.prepareToWrite();
        return clientSerializationStreamWriter;
    }

    @Override
    public String getServiceEntryPoint() {
        return this.remoteServiceURL;
    }

    @Override
    public void setRpcRequestBuilder(RpcRequestBuilder builder) {
        this.rpcRequestBuilder = builder;
    }

    @Override
    public void setServiceEntryPoint(String url) {
        this.remoteServiceURL = url;
    }

    protected <T> RequestCallback doCreateRequestCallback(RequestCallbackAdapter.ResponseReader responseReader, String methodName, int invocationCount, AsyncCallback<T> callback) {
        return new RequestCallbackAdapter<T>(this, methodName, invocationCount, callback, responseReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Request doInvoke(RequestCallbackAdapter.ResponseReader responseReader, String methodName, int invocationCount, String requestData, AsyncCallback<T> callback) {
        RequestBuilder rb = this.doPrepareRequestBuilderImpl(responseReader, methodName, invocationCount, requestData, callback);
        try {
            Request request = rb.send();
            return request;
        }
        catch (RequestException ex) {
            InvocationException iex = new InvocationException("Unable to initiate the asynchronous service invocation -- check the network connection", ex);
            callback.onFailure(iex);
        }
        finally {
            if (!RemoteServiceProxy.isStatsAvailable() || RemoteServiceProxy.stats(RemoteServiceProxy.bytesStat(methodName, invocationCount, requestData.length(), "requestSent"))) {
                // empty if block
            }
        }
        return null;
    }

    protected <T> RequestBuilder doPrepareRequestBuilder(RequestCallbackAdapter.ResponseReader responseReader, String methodName, int invocationCount, String requestData, AsyncCallback<T> callback) {
        RequestBuilder rb = this.doPrepareRequestBuilderImpl(responseReader, methodName, invocationCount, requestData, callback);
        return rb;
    }

    private <T> RequestBuilder doPrepareRequestBuilderImpl(RequestCallbackAdapter.ResponseReader responseReader, String methodName, int invocationCount, String requestData, AsyncCallback<T> callback) {
        if (this.getServiceEntryPoint() == null) {
            throw new ServiceDefTarget.NoServiceEntryPointSpecifiedException();
        }
        RequestCallback responseHandler = this.doCreateRequestCallback(responseReader, methodName, invocationCount, callback);
        this.ensureRpcRequestBuilder();
        this.rpcRequestBuilder.create(this.getServiceEntryPoint());
        this.rpcRequestBuilder.setCallback(responseHandler);
        this.rpcRequestBuilder.setContentType(RPC_CONTENT_TYPE);
        this.rpcRequestBuilder.setRequestData(requestData);
        this.rpcRequestBuilder.setRequestId(invocationCount);
        return this.rpcRequestBuilder.finish();
    }

    private void ensureRpcRequestBuilder() {
        if (this.rpcRequestBuilder == null) {
            this.rpcRequestBuilder = new RpcRequestBuilder();
        }
    }
}

