/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.tools.apichecker.ApiAbstractMethod;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiClass;
import com.google.gwt.tools.apichecker.ApiDiffGenerator;
import com.google.gwt.tools.apichecker.ApiField;
import com.google.gwt.tools.apichecker.ApiPackageDiffGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApiClassDiffGenerator
implements Comparable<ApiClassDiffGenerator> {
    static final Collection<ApiChange> EMPTY_COLLECTION = new ArrayList<ApiChange>(0);
    private final ApiDiffGenerator apiDiffGenerator;
    private final String className;
    private HashMap<ApiField, Set<ApiChange>> intersectingFields = null;
    private EnumMap<ApiClass.MethodType, Map<ApiAbstractMethod, Set<ApiChange>>> intersectingMethods;
    private Set<ApiField> missingFields = null;
    private EnumMap<ApiClass.MethodType, Set<ApiAbstractMethod>> missingMethods;
    private final ApiClass newClass;
    private final ApiClass oldClass;

    static String printSetWithHashCode(Set<?> set, String identifier) {
        StringBuffer sb = new StringBuffer();
        sb.append(identifier + ", size = " + set.size());
        for (Object element : set) {
            sb.append(element + ", hashcode = " + element.hashCode());
        }
        sb.append("\n");
        return sb.toString();
    }

    ApiClassDiffGenerator(String className, ApiPackageDiffGenerator apiPackageDiffGenerator) throws NotFoundException {
        this.className = className;
        this.apiDiffGenerator = apiPackageDiffGenerator.getApiDiffGenerator();
        this.newClass = apiPackageDiffGenerator.getNewApiPackage().getApiClass(className);
        this.oldClass = apiPackageDiffGenerator.getOldApiPackage().getApiClass(className);
        if (this.newClass == null || this.oldClass == null) {
            throw new NotFoundException("for class " + className + ", one of the class objects is null");
        }
        this.intersectingFields = new HashMap();
        this.intersectingMethods = new EnumMap(ApiClass.MethodType.class);
        this.missingMethods = new EnumMap(ApiClass.MethodType.class);
        for (ApiClass.MethodType methodType : ApiClass.MethodType.values()) {
            this.intersectingMethods.put(methodType, new HashMap());
        }
    }

    @Override
    public int compareTo(ApiClassDiffGenerator other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApiClassDiffGenerator)) {
            return false;
        }
        return this.getName().equals(((ApiClassDiffGenerator)o).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    void computeApiDiff() {
        Set<String> newFieldNames = this.newClass.getApiFieldNames();
        Set<String> oldFieldNames = this.oldClass.getApiFieldNames();
        Set<String> intersection = ApiDiffGenerator.removeIntersection(newFieldNames, oldFieldNames);
        this.missingFields = this.oldClass.getApiFieldsBySet(oldFieldNames);
        this.processFieldsInIntersection(intersection);
        for (ApiClass.MethodType methodType : ApiClass.MethodType.values()) {
            Set<String> newMethodNames = this.newClass.getApiMemberNames(methodType);
            Set<String> oldMethodNames = this.oldClass.getApiMemberNames(methodType);
            intersection = ApiDiffGenerator.removeIntersection(newMethodNames, oldMethodNames);
            this.missingMethods.put(methodType, this.oldClass.getApiMembersBySet(oldMethodNames, methodType));
            this.processElementsInIntersection(intersection, methodType);
        }
    }

    Collection<ApiChange> getApiDiff() {
        List<ApiChange.Status> apiStatusChanges = this.oldClass.getModifierChanges(this.newClass);
        ArrayList<ApiChange> apiChangeCollection = new ArrayList<ApiChange>();
        for (ApiChange.Status apiStatus : apiStatusChanges) {
            apiChangeCollection.add(new ApiChange(this.oldClass, apiStatus));
        }
        for (ApiField element : this.missingFields) {
            apiChangeCollection.add(new ApiChange(element, ApiChange.Status.MISSING));
        }
        apiChangeCollection.addAll(this.getIntersectingFields());
        for (ApiClass.MethodType methodType : ApiClass.MethodType.values()) {
            apiChangeCollection.addAll(this.getMissingMethods(methodType));
            apiChangeCollection.addAll(this.getIntersectingMethods(methodType));
        }
        return apiChangeCollection;
    }

    String getName() {
        return this.className;
    }

    private <T> void addProperty(Map<T, Set<ApiChange>> hashMap, T key, ApiChange property) {
        Set<ApiChange> value = hashMap.get(key);
        if (value == null) {
            value = new HashSet<ApiChange>();
        }
        value.add(property);
        hashMap.put(key, value);
    }

    private Collection<ApiChange> getIntersectingFields() {
        ArrayList<ApiChange> collection = new ArrayList<ApiChange>();
        ArrayList<ApiField> intersectingFieldsList = new ArrayList<ApiField>(this.intersectingFields.keySet());
        Collections.sort(intersectingFieldsList);
        for (ApiField apiField : intersectingFieldsList) {
            for (ApiChange apiChange : this.intersectingFields.get(apiField)) {
                collection.add(apiChange);
            }
        }
        return collection;
    }

    private Collection<ApiChange> getIntersectingMethods(ApiClass.MethodType methodType) {
        ArrayList<ApiChange> collection = new ArrayList<ApiChange>();
        ArrayList<ApiAbstractMethod> apiMethodsList = new ArrayList<ApiAbstractMethod>(this.intersectingMethods.get((Object)methodType).keySet());
        Collections.sort(apiMethodsList);
        for (ApiAbstractMethod apiMethod : apiMethodsList) {
            collection.addAll((Collection<ApiChange>)this.intersectingMethods.get((Object)methodType).get(apiMethod));
        }
        return collection;
    }

    private Collection<ApiChange> getMissingMethods(ApiClass.MethodType methodType) {
        ArrayList<ApiChange> collection = new ArrayList<ApiChange>();
        ArrayList apiMethodsList = new ArrayList(this.missingMethods.get((Object)methodType));
        Collections.sort(apiMethodsList);
        for (ApiAbstractMethod apiMethod : apiMethodsList) {
            collection.add(new ApiChange(apiMethod, ApiChange.Status.MISSING));
        }
        return collection;
    }

    private Map<ApiAbstractMethod, ApiChange> getOverloadedMethodIncompatibility(Set<ApiAbstractMethod> methodsInNew, Set<ApiAbstractMethod> methodsInExisting) {
        if (methodsInExisting.size() != 1 || methodsInNew.size() <= 1) {
            return Collections.emptyMap();
        }
        ApiAbstractMethod existingMethod = methodsInExisting.toArray(new ApiAbstractMethod[0])[0];
        String signature = existingMethod.getCoarseSignature();
        ArrayList<ApiAbstractMethod> matchingMethods = new ArrayList<ApiAbstractMethod>();
        for (ApiAbstractMethod current : methodsInNew) {
            if (!current.getCoarseSignature().equals(signature)) continue;
            matchingMethods.add(current);
        }
        if (this.isPairwiseCompatible(matchingMethods)) {
            return Collections.emptyMap();
        }
        HashMap<ApiAbstractMethod, ApiChange> incompatibilities = new HashMap<ApiAbstractMethod, ApiChange>();
        incompatibilities.put(existingMethod, new ApiChange(existingMethod, ApiChange.Status.OVERLOADED_METHOD_CALL, "Many methods in the new API with similar signatures. Methods = " + methodsInNew + " This might break API source compatibility"));
        return incompatibilities;
    }

    private boolean isPairwiseCompatible(List<ApiAbstractMethod> methods) {
        int length = methods.size();
        for (int i = 0; i < length - 1; ++i) {
            for (int j = i + 1; j < length; ++j) {
                ApiAbstractMethod secondMethod;
                ApiAbstractMethod firstMethod = methods.get(i);
                if (firstMethod.isCompatible(secondMethod = methods.get(j)) || secondMethod.isCompatible(firstMethod)) continue;
                return false;
            }
        }
        return true;
    }

    private void processElementsInIntersection(Set<String> intersection, ApiClass.MethodType methodType) {
        Set<ApiAbstractMethod> missingElements = this.missingMethods.get((Object)methodType);
        Map<ApiAbstractMethod, Set<ApiChange>> intersectingElements = this.intersectingMethods.get((Object)methodType);
        HashSet<ApiAbstractMethod> onlyInExisting = new HashSet<ApiAbstractMethod>();
        HashSet<ApiAbstractMethod> onlyInNew = new HashSet<ApiAbstractMethod>();
        HashSet<String> commonSignature = new HashSet<String>();
        for (String elementName : intersection) {
            Set<ApiAbstractMethod> methodsInNew = this.newClass.getApiMethodsByName(elementName, methodType);
            Set<ApiAbstractMethod> methodsInExisting = this.oldClass.getApiMethodsByName(elementName, methodType);
            onlyInNew.addAll(methodsInNew);
            onlyInExisting.addAll(methodsInExisting);
            Map<ApiAbstractMethod, ApiChange> incompatibilityMap = this.getOverloadedMethodIncompatibility(methodsInNew, methodsInExisting);
            for (Map.Entry<ApiAbstractMethod, ApiChange> entry : incompatibilityMap.entrySet()) {
                this.addProperty(intersectingElements, entry.getKey(), entry.getValue());
            }
            for (ApiAbstractMethod methodInExisting : methodsInExisting) {
                HashSet allPossibleApiChanges = new HashSet();
                ApiAbstractMethod sameSignatureMethod = null;
                for (ApiAbstractMethod methodInNew : methodsInNew) {
                    HashSet<ApiChange> currentApiChange = new HashSet<ApiChange>();
                    boolean hasSameSignature = false;
                    if (methodInExisting.isCompatible(methodInNew)) {
                        if (methodInExisting.isOverridable()) {
                            currentApiChange.addAll(methodInExisting.getAllChangesInApi(methodInNew));
                        } else {
                            currentApiChange.addAll(methodInExisting.checkExceptionsAndReturnType(methodInNew));
                        }
                        for (ApiChange.Status status : methodInExisting.getModifierChanges(methodInNew)) {
                            currentApiChange.add(new ApiChange(methodInExisting, status));
                        }
                        if (methodInNew.getInternalSignature().equals(methodInExisting.getInternalSignature())) {
                            currentApiChange.add(new ApiChange(methodInExisting, ApiChange.Status.COMPATIBLE));
                            hasSameSignature = true;
                        } else {
                            currentApiChange.add(new ApiChange(methodInExisting, ApiChange.Status.COMPATIBLE_WITH, methodInNew.getApiSignature()));
                        }
                    }
                    if (currentApiChange.size() <= 0) continue;
                    if (hasSameSignature) {
                        allPossibleApiChanges = currentApiChange;
                        sameSignatureMethod = methodInNew;
                        continue;
                    }
                    if (sameSignatureMethod != null) continue;
                    allPossibleApiChanges.addAll(currentApiChange);
                }
                if (allPossibleApiChanges.size() <= 0) continue;
                onlyInExisting.remove(methodInExisting);
                String signatureInExisting = methodInExisting.getInternalSignature();
                if (sameSignatureMethod != null && signatureInExisting.equals(sameSignatureMethod.getInternalSignature())) {
                    commonSignature.add(signatureInExisting);
                }
                for (ApiChange apiChange : allPossibleApiChanges) {
                    this.addProperty(intersectingElements, methodInExisting, apiChange);
                }
            }
            for (ApiAbstractMethod methodInNew : methodsInNew) {
                ApiAbstractMethod sameSignatureMethod = null;
                for (ApiAbstractMethod methodInExisting : methodsInExisting) {
                    if (!methodInNew.getInternalSignature().equals(methodInExisting.getInternalSignature())) continue;
                    sameSignatureMethod = methodInExisting;
                    break;
                }
                if (sameSignatureMethod != null) continue;
                for (ApiAbstractMethod methodInExisting : methodsInExisting) {
                    if (!methodInNew.isCompatible(methodInExisting)) continue;
                    for (ApiChange apiChange : methodInExisting.checkExceptionsAndReturnType(methodInNew)) {
                        this.addProperty(intersectingElements, methodInExisting, apiChange);
                    }
                }
            }
        }
        missingElements.addAll(onlyInExisting);
    }

    private void processFieldsInIntersection(Set<String> intersection) {
        for (String fieldName : intersection) {
            ApiField newField = this.newClass.getApiFieldByName(fieldName);
            ApiField oldField = this.oldClass.getApiFieldByName(fieldName);
            Set<ApiChange> apiChanges = oldField.getModifierChanges(newField);
            if (apiChanges.size() <= 0) continue;
            this.intersectingFields.put(oldField, apiChanges);
        }
    }
}

