/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiClass;
import com.google.gwt.tools.apichecker.ApiCompatibilityChecker;
import com.google.gwt.tools.apichecker.ApiElement;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApiField
implements Comparable<ApiField>,
ApiElement {
    private final ApiClass apiClass;
    private volatile String apiSignature = null;
    private final JField field;
    private volatile String relativeSignature = null;

    static String computeApiSignature(JField tempField) {
        return tempField.getEnclosingType().getQualifiedSourceName() + "::" + tempField.getName();
    }

    ApiField(JField field, ApiClass apiClass) {
        this.field = field;
        this.apiClass = apiClass;
    }

    @Override
    public int compareTo(ApiField other) {
        return this.getRelativeSignature().compareTo(other.getRelativeSignature());
    }

    public boolean equals(Object o) {
        if (o instanceof ApiField) {
            ApiField other = (ApiField)o;
            return this.getApiSignature().equals(other.getApiSignature());
        }
        return false;
    }

    public ApiClass getApiClass() {
        return this.apiClass;
    }

    @Override
    public String getRelativeSignature() {
        if (this.relativeSignature == null) {
            this.relativeSignature = this.computeRelativeSignature();
        }
        return this.relativeSignature;
    }

    public int hashCode() {
        return this.getApiSignature().hashCode();
    }

    public String toString() {
        return this.field.toString();
    }

    String getApiSignature() {
        if (this.apiSignature == null) {
            this.apiSignature = this.computeApiSignature();
        }
        return this.apiSignature;
    }

    JField getField() {
        return this.field;
    }

    Set<ApiChange> getModifierChanges(ApiField newField) {
        HashSet<ApiChange> statuses = new HashSet<ApiChange>();
        if (!this.field.isFinal() && newField.getField().isFinal()) {
            statuses.add(new ApiChange(this, ApiChange.Status.FINAL_ADDED));
        }
        if (this.field.isStatic() && !newField.getField().isStatic()) {
            statuses.add(new ApiChange(this, ApiChange.Status.STATIC_REMOVED));
        }
        return statuses;
    }

    private String computeApiSignature() {
        return ApiField.computeApiSignature(this.field);
    }

    private String computeRelativeSignature() {
        String signature = this.field.getName();
        if (ApiCompatibilityChecker.DEBUG) {
            JClassType enclosingType = this.field.getEnclosingType();
            return this.apiClass.getClassObject().getQualifiedSourceName() + "::" + signature + " defined in " + (enclosingType == null ? "null enclosing type " : enclosingType.getQualifiedSourceName());
        }
        return this.apiClass.getClassObject().getQualifiedSourceName() + "::" + signature;
    }
}

